﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using UnityEngine;

public class MissionsTimeConfiguration : ConfigurationElement
{
    public int RoundFactor;
    public float BaseSpeed;
    public MissionsTimeEasyConfiguration Easy;
    public MissionsTimeMediumConfiguration Medium;
    public MissionsTimeHardConfiguration Hard;

    public MissionsTimeConfiguration() : base("MissionsTime")
    {

    }

    public override bool Parse(XElement configElem)
    {
        try
        {
            RoundFactor = Convert.ToInt32(configElem.Element("RoundFactor").Value);
            BaseSpeed = Convert.ToSingle(configElem.Element("BaseSpeed").Value);

            Easy = new MissionsTimeEasyConfiguration();
            Medium = new MissionsTimeMediumConfiguration();
            Hard = new MissionsTimeHardConfiguration();

            if (Easy.Parse(configElem.Element("Easy")))
            {
                if (Medium.Parse(configElem.Element("Medium")))
                {
                    if (Hard.Parse(configElem.Element("Hard")))
                    {
                        return true;
                    }

                    else
                    {
                        Debug.LogError("ERROR: Failed to parse missions time hard configuration.");
                    }
                }

                else
                {
                    Debug.LogError("ERROR: Failed to parse missions time medium configuration.");
                }
            }

            else
            {
                Debug.LogError("ERROR: Failed to parse missions time easy configuration.");
            }

            return false;
        }

        catch (Exception ex)
        {
            Debug.LogError("ERROR: Caught an exception when parsing missions time configuration. The exception is: " + ex);
            Preloader.ExceptionMessage = ex.ToString();
            return false;
        }
    }
}
